/*
	File:		PartHandler.h

	Copyright:	 1992-1996 by Apple Computer, Inc., all rights reserved.

	Derived from v1 internal, 1/8/96.

*/


#ifndef __PARTHANDLER_H
#define __PARTHANDLER_H

#ifndef __NEWTONTYPES_H
#include "NewtonTypes.h"
#endif

#ifndef __OSERRORS_H
#include "OSErrors.h"
#endif

#ifndef __PACKAGETYPES_H
#include "PackageTypes.h"
#endif


//////////////////////////////////////////////////////////////////////////

class TAEventHandler;
class TPartEventHandler;
class TPkPartInstallEvent;
class TPkPartInstallEventReply;
class TPkPartRemoveEvent;
class TPkRegisterEvent;
class TEndpointPipe;
class CPipe;

class TUAsyncMessage;

TObjectId	PackageManagerPortId();
NewtonErr	LoadPackage( TEndpointPipe *pipe, TObjectId *packageId , Boolean willRemove = true );
NewtonErr	LoadPackage( CPipe *pipe, TObjectId *packageId , Boolean willRemove = true );

NewtonErr	LoadPackage( Ptr buffer,  SourceType type, TObjectId *packageId );
NewtonErr	LoadPackage( TEndpointPipe *pipe, SourceType type, TObjectId *packageId );
NewtonErr	LoadPackage( CPipe *pipe, SourceType type , TObjectId *packageId );

void		RemovePackage( TObjectId packageId );


//////////////////////////////////////////////////////////////////////////


class TPartHandler : public SingleObject {

public:

	TPartHandler();
	virtual	~TPartHandler();

		NewtonErr   Init( ULong type );

						// install and removal functions
	virtual	NewtonErr   Install( const PartId& partId, SourceType sourceType,  PartInfo *partInfo ) = 0;	// must override
	virtual NewtonErr 	Remove ( const PartId& partId, PartType   partType,    RemoveObjPtr	removePtr ) = 0;	// must override

						// backup methods
						// lastBackupDate is in minutes from the beginning of time
	virtual	NewtonErr 	GetBackupInfo( const PartId& partId, PartType partType, RemoveObjPtr removePtr , PartInfo *partInfo, ULong lastBackupDate, Boolean *needsBackup );
	virtual NewtonErr	Backup( const PartId& partId, RemoveObjPtr removePtr , CPipe *pipe );

protected:
						// Expand: user may override. Default action is to do a straight copy
	virtual NewtonErr	Expand( void *data, CPipe *pipe, PartInfo *info );

					// return information functions
	void			SetRemoveObjPtr( RemoveObjPtr obj );
	void			RejectPart();
	void			ReplyImmed( NewtonErr err );	// reply immediately to the package manager

					// query functions
	Ptr				GetSourcePtr();

					// load part functions

					// Copy
					// a function for copying data from the source.
					// It will do a straight copy for pointers, will call Expand() for pipes
	NewtonErr		Copy( 	void *data  );


private:

	friend 			TPartEventHandler;


	void 			Install( TPkPartInstallEvent *installEvent );
	void 			Remove ( TPkPartRemoveEvent  *removeEvent  );

	NewtonErr		Register();
	NewtonErr		Unregister();


	Long			fType;
	Long			fMaxInfoSize;

	SourceType		fSourceType;
	PartSource		fSource;

	PartInfo		*fPartInfo;

	RemoveObjPtr	fRemoveObjPtr;
	Boolean			fAccept;

	Boolean			fInitFailed;

	TAEventHandler *fEventHandler;

	// async message stuff for registering and replying

	TUAsyncMessage 				*fAsyncMessage;
	TPkRegisterEvent 			*fRegisterEvent;
	Boolean						fReplied;

	// device info
};


#endif
